<?php $__env->startSection('title', 'Riwayat Absensi'); ?>

<?php $__env->startSection('content'); ?>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    .fullscreen-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #ffffff;
    }

    /* Header Bar */
    .header-bar {
        margin-top: 70px;
        background: #2d2d2e;
        color: white;
        padding: 18px 20px;
        display: flex;
        align-items: center;
        gap: 16px;
        flex-shrink: 0;
    }



    .header-title {
        font-size: 18px;
        font-weight: 500;
    }

    /* Filter Section */
    .filter-section {
        margin-top: 70px;
        background: #f8f9fa;
        padding: 14px 20px;
        border-bottom: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .month-selector {
        display: flex;
        align-items: center;
        gap: 10px;
        padding: 10px 14px;
        background: white;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        cursor: pointer;
    }

    .month-selector i {
        color: #6c757d;
        font-size: 16px;
    }

    .month-text {
        flex: 1;
        font-size: 14px;
        color: #495057;
        font-weight: 500;
    }

    .month-input {
        display: none;
    }

    /* Absensi List */
    .absensi-list {
        margin-bottom: 70px;
        flex: 1;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        background: #ffffff;
    }

    /* List Item */
    .list-item {
        padding: 16px 20px;
        border-bottom: 1px solid #f0f0f0;
        display: flex;
        align-items: center;
        gap: 16px;
        background: white;
        transition: background 0.2s;
    }

    .list-item:active {
        background: #fafafa;
    }

    .list-item.today {
        background: #f8fbff;
    }

    /* Date Column */
    .date-col {
        display: flex;
        align-items: center;
        gap: 12px;
        flex: 1;
    }

    .date-box {
        width: 48px;
        height: 48px;
        background: #354591;
        color: white;
        border-radius: 8px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }

    .date-num {
        font-size: 18px;
        font-weight: 700;
        line-height: 1;
    }

    .date-month {
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        opacity: 0.8;
        margin-top: 2px;
    }

    .date-info {
        flex: 1;
    }

    .day-name {
        font-size: 15px;
        font-weight: 600;
        color: #212529;
        margin-bottom: 2px;
    }

    .full-date {
        font-size: 12px;
        color: #6c757d;
    }

    /* Time Column */
    .time-col {
        display: flex;
        gap: 16px;
        align-items: center;
    }

    .time-item {
        text-align: center;
        min-width: 50px;
    }

    .time-label {
        font-size: 10px;
        color: #6c757d;
        margin-bottom: 2px;
        text-transform: uppercase;
        font-weight: 600;
    }

    .time-value {
        font-size: 15px;
        font-weight: 600;
        color: #212529;
    }

    .time-value.empty {
        color: #adb5bd;
    }

    /* Status Badge */
    .status-badge {
        padding: 4px 10px;
        border-radius: 4px;
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }

    .status-badge.hadir {
        background: #d4edda;
        color: #155724;
    }

    .status-badge.terlambat {
        background: #fff3cd;
        color: #856404;
    }

    .status-badge.alpha {
        background: #f8d7da;
        color: #721c24;
    }

    .status-badge.izin {
        background: #d1ecf1;
        color: #0c5460;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
    }

    .empty-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 16px;
        background: #f8f9fa;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #adb5bd;
        font-size: 28px;
    }

    .empty-state h3 {
        font-size: 16px;
        color: #495057;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .empty-state p {
        font-size: 13px;
        color: #adb5bd;
    }

    /* Pagination */
    .pagination-wrapper {
        padding: 16px 20px;
        background: white;
        border-top: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .pagination {
        display: flex;
        justify-content: center;
        gap: 6px;
        margin: 0;
        padding: 0;
        list-style: none;
    }

    .pagination a,
    .pagination span {
        width: 36px;
        height: 36px;
        border-radius: 6px;
        font-size: 13px;
        color: #495057;
        text-decoration: none;
        background: #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        transition: all 0.2s;
    }

    .pagination a:hover {
        background: #2d2d2e;
        color: white;
    }

    .pagination .active span {
        background: #2d2d2e;
        color: white;
    }

    .pagination .disabled span {
        opacity: 0.4;
        cursor: not-allowed;
    }
</style>

<div class="fullscreen-wrapper">
    <!-- Header -->

    <!-- Filter -->
    <div class="filter-section">
        <label for="bulan" class="month-selector">
            <i class="far fa-calendar-alt"></i>
            <span class="month-text">
                <?php echo e(\Carbon\Carbon::parse($bulan ?? date('Y-m'))->translatedFormat('F Y')); ?>

            </span>
            <i class="fas fa-chevron-down" style="font-size: 12px;"></i>
        </label>
        <form method="GET" id="filterForm" style="display: none;">
            <input type="month" name="bulan" id="bulan" value="<?php echo e($bulan ?? date('Y-m')); ?>"
                   class="month-input" onchange="this.form.submit()">
        </form>
    </div>

    <!-- List -->
    <div class="absensi-list">
        <?php $__empty_1 = true; $__currentLoopData = $absensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $tanggal = \Carbon\Carbon::parse($row->tanggal);
                $isToday = $tanggal->isToday();
            ?>

            <div class="list-item <?php echo e($isToday ? 'today' : ''); ?>">
                <div class="date-col">
                    <div class="date-box">
                        <div class="date-num"><?php echo e($tanggal->format('d')); ?></div>
                        <div class="date-month"><?php echo e($tanggal->format('M')); ?></div>
                    </div>
                    <div class="date-info">
                        <div class="day-name"><?php echo e($tanggal->translatedFormat('l')); ?></div>
                        <div class="full-date"><?php echo e($tanggal->translatedFormat('d F Y')); ?></div>
                    </div>
                </div>

                <div class="time-col">
                    <div class="time-item">
                        
                        <div class="time-value <?php echo e($row->jam_masuk ? '' : 'empty'); ?>">
                            <?php echo e($row->jam_masuk ? date('H:i', strtotime($row->jam_masuk)) : '--:--'); ?>

                        </div>
                    </div>

                    <div class="time-item">
                        
                        <div class="time-value <?php echo e($row->jam_pulang ? '' : 'empty'); ?>">
                            <?php echo e($row->jam_pulang ? date('H:i', strtotime($row->jam_pulang)) : '--:--'); ?>

                        </div>
                    </div>
                </div>

                <?php if($row->status == 'hadir'): ?>
                    <span class="status-badge hadir">Hadir</span>
                <?php elseif($row->status == 'terlambat'): ?>
                    <span class="status-badge terlambat">Terlambat</span>
                <?php elseif($row->status == 'alpha'): ?>
                    <span class="status-badge alpha">Alpha</span>
                <?php elseif($row->status == 'izin'): ?>
                    <span class="status-badge izin">Izin</span>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="far fa-calendar-times"></i>
                </div>
                <h3>Tidak ada data</h3>
                <p>Belum ada riwayat absensi bulan ini</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if(isset($absensi) && method_exists($absensi, 'hasPages') && $absensi->hasPages()): ?>
        <div class="pagination-wrapper">
            <?php echo e($absensi->appends(['bulan' => $bulan ?? date('Y-m')])->links()); ?>

        </div>
    <?php endif; ?>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Month picker
    document.querySelector('.month-selector').addEventListener('click', function() {
        document.getElementById('bulan').showPicker();
    });

    // Touch feedback
    const items = document.querySelectorAll('.list-item');
    items.forEach(item => {
        item.addEventListener('touchstart', () => {
            item.style.transform = 'scale(0.98)';
        });
        item.addEventListener('touchend', () => {
            item.style.transform = 'scale(1)';
        });
    });

    // Auto scroll to today
    const todayItem = document.querySelector('.list-item.today');
    if (todayItem) {
        setTimeout(() => {
            todayItem.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 300);
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('karyawan.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/karyawan/absensi/log.blade.php ENDPATH**/ ?>